const https = require('https');
const fs = require('fs');
const path = require('path');

// Ler config
const configPath = path.join(__dirname, 'config.json');
const config = JSON.parse(fs.readFileSync(configPath, 'utf8'));

console.log('--- TESTE TELEGRAM ---');
console.log('Token:', config.telegramBotToken ? 'OK (Carregado)' : 'FALHA (Vazio)');
console.log('Chat ID:', config.telegramChatId ? config.telegramChatId : 'FALHA (Vazio)');

if (!config.telegramBotToken || !config.telegramChatId) {
    console.error('❌ Configuração incompleta!');
    process.exit(1);
}

const message = '🔔 TESTE: Se você recebeu isso, seu bot está funcionado!';
const encodedMessage = encodeURIComponent(message);
const url = `https://api.telegram.org/bot${config.telegramBotToken}/sendMessage?chat_id=${config.telegramChatId}&text=${encodedMessage}`;

console.log('Enviando requisição...');

https.get(url, (res) => {
    let data = '';

    res.on('data', (chunk) => {
        data += chunk;
    });

    res.on('end', () => {
        console.log('Status Code:', res.statusCode);
        console.log('Response:', data);

        const parsed = JSON.parse(data);
        if (parsed.ok) {
            console.log('✅ SUCESSO! Verifique seu Telegram.');
        } else {
            console.error('❌ ERRO NA API:', parsed.description);
        }
    });

}).on('error', (e) => {
    console.error('❌ ERRO DE REDE:', e.message);
});
